const url = require('url').URL;

// Creating an URL object
const myUrl = new url('http://mywebsite.com/hello.html?id=100&status=active');

// Getting the serialized URL
console.log(myUrl.href);
console.log(myUrl.toString());

// Getting the host (root domain)
console.log(myUrl.host);

// Getting the host name (does not get port)
console.log(myUrl.hostname);

// Getting the path name
console.log(myUrl.pathname);

// Getting the serialized query
console.log(myUrl.search);

// Getting an object with the search params
console.log(myUrl.searchParams);

// Adding params
myUrl.searchParams.append('test', 123);
console.log(myUrl.searchParams);

// Loop through params
myUrl.searchParams.forEach((value, name) => console.log(`${name}: ${value}`));